/*
 * Exhibit.java
 *
 * Created on June 6, 2002, 9:05 AM
 */

package PER.exhibit;

import PER.exhibit.GUI.*;
import PER.rover.Rover;
import PER.rover.Log;
import javax.swing.*;
import java.io.*;

/**
 * The main class of the PER Exhibit kiosk software. This is the overall 
 * frame for displaying everything.
 * <p>
 * Run this class directly.
 *
 * @author  Rachel Gockley
 */
public class Exhibit extends javax.swing.JFrame {
    
    public static final String exhibitPath = PER.PERConstants.perPath+"exhibit/"; //path to the Exhibit directory
    
    /** Creates new form Exhibit */
    public Exhibit() {
        fc = null;
    }
    
    public void initialize(Rover rov) {
        System.err.println("beginning initialization...");
        Sequencer exhibitSequencer = new Sequencer(rov);
        MissionProgressPanel mpp = new MissionProgressPanel(exhibitSequencer);
        //rov.mySequencer.setMissionProgressPanel(mpp);
        exhibitSequencer.setMissionProgressPanel(mpp);
        
        fc = new FlowController(rov, mpp, exhibitSequencer);
        
        getContentPane().add(fc);
        
        initComponents();
        System.err.println("initialization complete!");
    }
    
    public void startDisplay() {
        if (fc != null)
            fc.startTimer();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle("Personal Rover Project");
        setBackground(java.awt.Color.white);
        setResizable(false);
        setUndecorated(true);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        pack();
    }//GEN-END:initComponents
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
/*        int rsp = javax.swing.JOptionPane.showConfirmDialog(this,
            "Closing this program will stop all Trikebot activity. You must\n"
            + "leave this program running for missions to continue to run. Are\n"
            + "you sure you want to exit?", "Closing",
            javax.swing.JOptionPane.YES_NO_OPTION,
            javax.swing.JOptionPane.WARNING_MESSAGE);
 */
        //        if (rsp == javax.swing.JOptionPane.YES_OPTION) {
        PER.rover.StatsLog.println(PER.rover.StatsLog.PROGRAM_CLOSED);
        PER.rover.Log.println("Program Closed.");
        System.exit(0);
        //        }
    }//GEN-LAST:event_exitForm
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        final Object lock = new Object();
        final Exhibit frame = new Exhibit();
        final Rover rov = new Rover();
        
        //init log files
        //make sure topLevelDir exists
        java.io.File f = new java.io.File(Rover.topLevelDir);
        if(!f.exists()){
            f.mkdirs();
        }
        
        PER.rover.Log.initLogFile("exhibitRover.Log");
        PER.rover.StatsLog.initLogFile("exhibitStatsLog.txt");
        PER.rover.MiniLog.initLogFile("exhibitMiniLog.txt");
        
        StartUpDialog start = new StartUpDialog(null, rov);
        
        // load the exhibit GUI in the background
        Thread loader = new Thread() {
            public void run() {
                synchronized (lock) {
                    frame.initialize(rov);
                    lock.notify();
                }
            }
        };
        loader.start();
        
        // connect to the rover
        start.show();
        
        int button = start.getButtonPressed();
        start.dispose();
        
        // if the user cancelled
        if (button == StartUpDialog.CANCEL_BUTTON)
            System.exit(-1);
        
        // otherwise, we're now connected to the rover
        
        // wait for the exhibit to finish loading, then display it!
        synchronized (lock) {
            //set the satellite map image and coordinates
            if(!frame.fc.setMapImageAndCoordinates(start.getMapImage(),
            start.getRolloverImage(),
            start.getMapCoordinatesFile())){
                System.exit(0); //??
            }
            //set final delay for roverPOVScreen
            frame.fc.setPOVDelay();
            //set panorama angle
            frame.fc.setPanoramaAngle(start.getPanoramaAngle());
            
            java.awt.GraphicsDevice device = java.awt.GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            boolean isFullScreen = device.isFullScreenSupported();
            
            frame.startDisplay();
            
            if (isFullScreen) {
                // Full-screen mode
                device.setFullScreenWindow(frame);
                frame.validate();
            } else {
                // Windowed mode
                frame.show();
            }
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    public FlowController fc;
}
